<?php
/**
 * update_prices.php - نسخه بیت‌پین (Bitpin) با قابلیت ارسال به تاپیک
 */

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// --- 1. بارگذاری نیازمندی‌ها ---
if (file_exists('config.php')) require_once 'config.php';
elseif (file_exists('../config.php')) require_once '../config.php';

if (file_exists('class/Base.php')) require_once 'class/Base.php';
elseif (file_exists('../class/Base.php')) require_once '../class/Base.php';

require_once 'jdf.php';

// --- 2. تنظیمات تاپیک و گروه ---
$adminGroupId = "-1003325490390"; // آیدی عددی سوپرگروه مدیریت را اینجا قرار دهید

$topics = [
    'prices' => 143, // آیدی تاپیک گزارش قیمت خام (تتر و تون)
    'final_prices' => 153, // آیدی تاپیک قیمت نهایی + سود (برای اطلاع ادمین از قیمت فروش)
];

// بررسی تنظیمات اولیه
if (!isset($token)) {
    die("Error: Token missing in config.php");
}

$MahdyarEn = new Base($token);

// تابع دریافت اطلاعات (Curl)
function fetchUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

// --- 3. دریافت قیمت‌ها از بیت‌پین ---
$apiUrl = "https://api.bitpin.ir/v1/mkt/markets/";
$response = fetchUrl($apiUrl);
$json = json_decode($response, true);

$logMessages = [];
$hasError = false;
$usdt_toman = 0;
$ton_usd = 0;

if (isset($json['results'])) {
    foreach ($json['results'] as $market) {
        // الف) پیدا کردن قیمت تتر (USDT_IRT)
        if ($market['code'] == 'USDT_IRT') {
            $usdt_toman = intval($market['price']);
            
            // آپدیت دیتابیس
            $sql_usd = "UPDATE settings SET columnTwo = '$usdt_toman' WHERE type_id = 'usd_irr'";
            if ($db->query($sql_usd)) {
                $logMessages[] = "💵 <b>دلار (تتر):</b> " . number_format($usdt_toman) . " تومان";
            } else {
                $hasError = true;
                $logMessages[] = "❌ خطا در ذخیره قیمت دلار";
            }
        }

        // ب) پیدا کردن قیمت تون (TON_USDT)
        if ($market['code'] == 'TON_USDT') {
            $ton_usd = floatval($market['price']);
            
            // آپدیت دیتابیس
            $sql_ton = "UPDATE settings SET columnTwo = '$ton_usd' WHERE type_id = 'ton_price_usd'";
            if ($db->query($sql_ton)) {
                $logMessages[] = "💎 <b>تون کوین:</b> $ton_usd دلار";
            } else {
                $hasError = true;
                $logMessages[] = "❌ خطا در ذخیره قیمت تون";
            }
        }
    }
    
    // اگر تون به دلار پیدا نشد، از تون به تومان استفاده کن و تبدیل کن
    if ($ton_usd == 0 && $usdt_toman > 0) {
        foreach ($json['results'] as $market) {
            if ($market['code'] == 'TON_IRT') {
                $ton_toman = intval($market['price']);
                $ton_usd = round($ton_toman / $usdt_toman, 2);
                
                $db->query("UPDATE settings SET columnTwo = '$ton_usd' WHERE type_id = 'ton_price_usd'");
                $logMessages[] = "💎 <b>تون کوین (محاسباتی):</b> $ton_usd دلار";
            }
        }
    }

} else {
    $hasError = true;
    $logMessages[] = "❌ خطا در دریافت اطلاعات از بیت‌پین (خروجی نامعتبر)";
}

// --- 4. ارسال گزارش قیمت خام به تاپیک اول ---
$time = jdate("H:i:s");
$date = jdate("Y/m/d");

$header = $hasError ? "⚠️ <b>هشدار: خطا در آپدیت قیمت‌ها</b>" : "♻️ <b>قیمت‌ها آپدیت شد (Bitpin)</b>";

$finalMsg = "$header\n────────────────\n" . implode("\n", $logMessages) . "\n────────────────\n📅 $date | ⏰ $time";

// ارسال گزارش اول (قیمت خام)
$params = [
    'chat_id' => $adminGroupId,
    'text' => $finalMsg,
    'parse_mode' => 'html',
    'disable_web_page_preview' => true
];
if (isset($topics['prices'])) {
    $params['message_thread_id'] = $topics['prices'];
}
$MahdyarEn->Sendmessage($params);


// --- 5. محاسبه و ارسال قیمت نهایی (فروش) به تاپیک دوم ---
if (!$hasError && $usdt_toman > 0) {
    // دریافت درصد سود از دیتابیس
    $profit_query = $db->query("SELECT * FROM settings WHERE `type` = 'profit_margin'")->fetch_assoc();
    $profit_margin = isset($profit_query['type_id']) ? floatval($profit_query['type_id']) : 0;
    
    // محاسبه قیمت‌های فروش (طبق فرمول‌های ربات)
    // 1 + profit_margin یعنی قیمت اصلی + سود
    
    // پرمیوم‌ها (قیمت دلاری ضربدر تتر ضربدر سود)
    $final_prem3 = 11.99 * $usdt_toman * (1 + $profit_margin);
    $final_prem6 = 15.99 * $usdt_toman * (1 + $profit_margin);
    $final_prem12 = 28.99 * $usdt_toman * (1 + $profit_margin);
    
    // تون کوین (قیمت دلاری تون ضربدر تتر ضربدر سود)
    $final_ton_toman = ($ton_usd > 0 ? $ton_usd : 0) * $usdt_toman * (1 + $profit_margin);
    
    // استارز (هر استارز 0.015 دلار فرض شده)
    $final_star_toman = 0.015 * $usdt_toman * (1 + $profit_margin);
    
    $profit_percent = $profit_margin * 100;

    $finalMsgPrice = "💰 <b>لیست قیمت نهایی فروش (با $profit_percent% سود)</b>\n";
    $finalMsgPrice .= "────────────────\n";
    $finalMsgPrice .= "🗽 <b>پرمیوم 3 ماهه:</b> " . number_format(ceil($final_prem3/1000)*1000) . " تومان\n"; // رند شده به بالا
    $finalMsgPrice .= "🗽 <b>پرمیوم 6 ماهه:</b> " . number_format(ceil($final_prem6/1000)*1000) . " تومان\n";
    $finalMsgPrice .= "🗽 <b>پرمیوم 12 ماهه:</b> " . number_format(ceil($final_prem12/1000)*1000) . " تومان\n";
    $finalMsgPrice .= "────────────────\n";
    if ($final_ton_toman > 0) {
        $finalMsgPrice .= "💎 <b>هر تون کوین:</b> " . number_format(ceil($final_ton_toman)) . " تومان\n";
    }
    $finalMsgPrice .= "⭐️ <b>هر استارز:</b> " . number_format(ceil($final_star_toman)) . " تومان\n";
    $finalMsgPrice .= "────────────────\n";
    $finalMsgPrice .= "📅 $date | ⏰ $time";

    // پارامترهای ارسال قیمت نهایی
    $paramsPrice = [
        'chat_id' => $adminGroupId,
        'text' => $finalMsgPrice,
        'parse_mode' => 'html',
        'disable_web_page_preview' => true
    ];

    // افزودن آیدی تاپیک دوم
    if (isset($topics['final_prices'])) {
        $paramsPrice['message_thread_id'] = $topics['final_prices'];
    }

    // ارسال گزارش دوم
    $MahdyarEn->Sendmessage($paramsPrice);
    echo " and Final Prices sent to topic " . ($topics['final_prices'] ?? 'General') . ".";
}

echo "Update Done.";
?>