<?php
/**
 * group_currency.php - نسخه V250 (Fixed & Debugged)
 * ویژگی‌ها: رفع باگ تبدیل ارز، اصلاح قیمت استارز، پشتیبانی کامل از لیست‌ها
 */

// تنظیمات دیباگ
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/bot_errors.log');

// جلوگیری از دسترسی مستقیم
if (!isset($chat_id) || !isset($text) || !isset($MahdyarEn)) return;

global $db, $starsPrice, $prem3; 

$current_chat_id = (string)$chat_id;

// تنظیمات گروه‌های مجاز
$allowed_groups = isset($currencyGroup) ? (is_array($currencyGroup) ? $currencyGroup : [$currencyGroup]) : [];
$allowed_groups = array_map('strval', $allowed_groups);

// ============================================================
// ⚙️ تنظیمات شخصی (اینجا را چک کنید)
// ============================================================
$channel_url = "https://t.me/tellgamin";      // لینک کانال
$channel_name = "📢 کانال اصلی";             // متن دکمه
$my_bot_username = "TellgaminBot";           // آیدی ربات (بدون @)
// ============================================================

if (in_array($current_chat_id, $allowed_groups)) {

    $raw_text = trim($text);
    $clean_text = trim(strtolower($text));
    
    // ✅ تبدیل تمام اعداد فارسی به انگلیسی در ابتدای کار
    $clean_text = convert_all_digits_to_en($clean_text);

    // ------------------------------------------------------------
    // 💎 سناریو ۱: لیست انانیموس
    // ------------------------------------------------------------
    if (in_array($clean_text, ['انانیموس', 'آنانیموس', 'anonymous', 'شماره مجازی', 'anonym'])) {
        $MahdyarEn->sendChatAction(['chat_id' => $chat_id, 'action' => 'typing']);
        $output = get_cheapest_anonymous_numbers();
        $kb = json_encode(['inline_keyboard' => [
            [['text' => "🔗 مشاهده لیست کامل", 'url' => "https://fragment.com/numbers?sort=price_asc&filter=sale"]],
            [['text' => $channel_name, 'url' => $channel_url]]
        ]]);
        send_final_message($chat_id, $message_id, $output['text'], $kb);
        exit();
    }

    // ------------------------------------------------------------
    // 👛 سناریو ۲: بررسی کیف پول TON
    // ------------------------------------------------------------
    if (preg_match('/^([E|U]Q[a-zA-Z0-9_-]{46})$/', $raw_text, $wallet_match)) {
        $MahdyarEn->sendChatAction(['chat_id' => $chat_id, 'action' => 'typing']);
        $output = analyze_ton_wallet($wallet_match[1]);
        $kb = json_encode(['inline_keyboard' => [[['text' => "🔍 TonViewer", 'url' => "https://tonviewer.com/".$wallet_match[1]]], [['text' => $channel_name, 'url' => $channel_url]]]]);
        send_final_message($chat_id, $message_id, $output['text'], $kb);
        exit();
    }

    // ------------------------------------------------------------
    // 🎁 سناریو ۳: استعلام قیمت گیفت
    // ------------------------------------------------------------
    if (preg_match('/^(?:gift|گیفت|قیمت گیفت)\s+(.+)$/u', $clean_text, $gift_match)) {
        $MahdyarEn->sendChatAction(['chat_id' => $chat_id, 'action' => 'typing']);
        $output = get_telegram_gift_price(trim($gift_match[1]));
        $kb = json_encode(['inline_keyboard' => [[['text' => "🎁 مارکت فرگمنت", 'url' => "https://fragment.com/gifts"]], [['text' => $channel_name, 'url' => $channel_url]]]]);
        send_final_message($chat_id, $message_id, $output['text'], $kb);
        exit();
    }

    // ------------------------------------------------------------
    // 📞 سناریو ۴: بررسی شماره/یوزرنیم
    // ------------------------------------------------------------
    if (preg_match('/^(?:check|fragment|فرگمنت|بررسی)\s+(?:@|\+)?([a-zA-Z0-9_]{4,32})$/u', $clean_text, $m)) {
        $val = $m[1];
        $MahdyarEn->sendChatAction(['chat_id' => $chat_id, 'action' => 'typing']);
        
        if (is_numeric(substr($val, 0, 3)) && strpos($val, '888') === 0) {
             $output = analyze_fragment_generic('number', $val);
             $url = "https://fragment.com/number/$val";
        } else {
             $output = analyze_fragment_generic('username', $val);
             $url = "https://fragment.com/username/$val";
        }
        $kb = json_encode(['inline_keyboard' => [[['text' => "🔗 مشاهده", 'url' => $url]], [['text' => $channel_name, 'url' => $channel_url]]]]);
        send_final_message($chat_id, $message_id, $output['text'], $kb);
        exit();
    }

    // ------------------------------------------------------------
    // 🧮 سناریو ۵: ماشین حساب (تبدیل ارز)
    // ------------------------------------------------------------
    if (preg_match('/^(?:تبدیل|convert)\s*(\d+(?:\.\d+)?)\s+(.+?)\s+(?:به|to)\s+(.+)$/u', $clean_text, $conv_match)) {
        $MahdyarEn->sendChatAction(['chat_id' => $chat_id, 'action' => 'typing']);
        $output = process_conversion(floatval($conv_match[1]), trim($conv_match[2]), trim($conv_match[3]));
        $kb = json_encode(['inline_keyboard' => [[['text' => $channel_name, 'url' => $channel_url]]]]);
        send_final_message($chat_id, $message_id, $output['text'], $kb);
        exit();
    }

    // ------------------------------------------------------------
    // 📊 سناریو ۶: قیمت ارز / پرمیوم / لیست
    // ------------------------------------------------------------
    $quantity = 1; 
    if (preg_match('/^(\d+)\s+(.+)$/u', $clean_text, $matches)) {
        $quantity = intval($matches[1]);
        $currency_name = trim($matches[2]);
        $clean_text = $currency_name;
    }

    $keywords = [
        'نرخ'=>'ALL', 'قیمت'=>'ALL', 'لیست'=>'ALL', 'مارکت'=>'ALL',
        'پرمیوم'=>'PREMIUM_ONLY', 'premium'=>'PREMIUM_ONLY',
        'استارز'=>'STARS_ONLY', 'استار'=>'STARS_ONLY', 'ستاره'=>'STARS_ONLY', 'star'=>'STARS_ONLY', 'stars'=>'STARS_ONLY',
        'تتر'=>'tether', 'usdt'=>'tether', 'دلار'=>'tether',
        'تون'=>'the-open-network', 'ton'=>'the-open-network',
        'بیت'=>'bitcoin', 'btc'=>'bitcoin', 'نات'=>'notcoin', 'not'=>'notcoin',
        'ترون'=>'tron', 'trx'=>'tron', 'سولانا'=>'solana', 'sol'=>'solana',
        'دوج'=>'dogecoin', 'doge'=>'dogecoin', 'شیبا'=>'shiba-inu', 'shib'=>'shiba-inu',
        'پپه'=>'pepe', 'همستر'=>'hamster-kombat', 'داگز'=>'dogs-2', 'کتز'=>'cats-2',
        'ایکس'=>'x-empire', 'میجر'=>'major', 'بایننس'=>'binancecoin', 'ریپل'=>'ripple',
        'لایت'=>'litecoin', 'اتریوم'=>'ethereum', 'eth'=>'ethereum'
    ];

    $target_id = $keywords[$clean_text] ?? null;
    
    if ($target_id) {
        $MahdyarEn->sendChatAction(['chat_id' => $chat_id, 'action' => 'typing']);
        
        if ($target_id == 'ALL') $output = get_generic_list();
        elseif ($target_id == 'PREMIUM_ONLY') $output = get_premium_list_fixed();
        else $output = calculate_unified_price($target_id, $quantity);
        
        $btns = [[['text' => $channel_name, 'url' => $channel_url]]];
        if ($target_id == 'STARS_ONLY') array_unshift($btns, [['text' => "⭐️ خرید آنی $quantity استارز", 'url' => "https://t.me/$my_bot_username?start=stars_$quantity"]]);
        if ($target_id == 'PREMIUM_ONLY') array_unshift($btns, [['text' => "💎 خرید پرمیوم", 'url' => "https://t.me/$my_bot_username?start=buyPremium"]]);
        
        send_final_message($chat_id, $message_id, $output['text'], json_encode(['inline_keyboard' => $btns]));
        exit();
    }
}

// ======================================================================
// 🔄 توابع اصلی و لاجیک
// ======================================================================

function get_premium_list_fixed() {
    global $db;
    $usdt_rate = get_setting_val('usd_irr', 70000);
    $margin = get_setting_val('profit_margin', 0);
    
    $p3_usd = get_setting_val('prem3_usd', 14.99);
    $p6_usd = get_setting_val('prem6_usd', 28.99);
    $p12_usd = get_setting_val('prem12_usd', 49.99);

    if($p3_usd <= 0) $p3_usd = 14.99;
    if($p6_usd <= 0) $p6_usd = 28.99;
    if($p12_usd <= 0) $p12_usd = 49.99;

    $p3_toman = number_format($p3_usd * $usdt_rate * (1 + $margin));
    $p6_toman = number_format($p6_usd * $usdt_rate * (1 + $margin));
    $p12_toman = number_format($p12_usd * $usdt_rate * (1 + $margin));

    $out = "💎 <b>Telegram Premium Rates:</b>\n";
    $out .= "<blockquote>";
    $out .= "📅 3 Months : $p3_toman T\n";
    $out .= "📅 6 Months : $p6_toman T\n";
    $out .= "📅 12 Months : $p12_toman T";
    $out .= "</blockquote>\n";
    $out .= get_clean_date();
    
    return ['text' => $out];
}

function get_clean_date() {
    date_default_timezone_set('Asia/Tehran');
    if (function_exists('jdate')) {
        return "🗓 " . convert_all_digits_to_en(jdate("Y/m/d | H:i:s"));
    }
    return "🗓 " . date("Y/m/d | H:i:s");
}

function convert_all_digits_to_en($string) {
    $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
    $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    $string = str_replace($persian, $english, $string);
    $string = str_replace($arabic, $english, $string);
    return $string;
}

function get_cheapest_anonymous_numbers() {
    global $db;
    $usdt = get_setting_val('usd_irr', 70000);
    $q_ton = $db->query("SELECT columnTwo FROM settings WHERE type_id='ton_price_usd'");
    $ton_usd = ($q_ton && $q_ton->num_rows > 0) ? $q_ton->fetch_assoc()['columnTwo'] : 5.5;

    $url = "https://fragment.com/numbers?sort=price_asc&filter=sale";
    $html = fetch_url_advanced($url);

    $out = "📞 <b>ارزان‌ترین شماره‌های انانیموس (+888):</b>\n➖➖➖➖➖➖➖➖➖➖\n";
    $found = false;

    if ($html) {
        preg_match_all('/href="\/number\/(888[0-9]+)"[^>]*>.*?([\d,]+(\.\d+)?)/s', $html, $matches, PREG_SET_ORDER);
        if (empty($matches)) {
            preg_match_all('/href="\/number\/(888[0-9]+)"[^>]*>.*?icon-ton"><\/i>\s*([\d,]+)/s', $html, $matches, PREG_SET_ORDER);
        }
        if (!empty($matches)) {
            $count = 0;
            foreach ($matches as $match) {
                if ($count >= 3) break;
                $number = $match[1];
                $price_ton = floatval(str_replace(',', '', $match[2]));
                if ($price_ton <= 0) continue;

                $price_toman = number_format($price_ton * $ton_usd * $usdt);
                $price_ton_fmt = number_format($price_ton);
                $fmt_number = "+888 " . substr($number, 3);

                $out .= "<b>$fmt_number</b>\n<blockquote>💎 Price: $price_ton_fmt TON\n💴 Toman: $price_toman T</blockquote>\n";
                $count++;
                $found = true;
            }
        }
    }
    if (!$found) $out .= "⚠️ <b>لیست آنلاین در دسترس نیست.</b>\n👇 برای مشاهده لیست زنده، دکمه زیر را بزنید.";
    $out .= "\n" . get_clean_date();
    return ['text' => $out];
}

// ------------------------------------------------------------
// 🛠 محاسبه قیمت تکی (همراه با فیکس استارز)
// ------------------------------------------------------------
function calculate_unified_price($coin_id, $quantity) {
    global $db, $starsPrice; 
    $usdt = get_setting_val('usd_irr', 70000);
    $margin = get_setting_val('profit_margin', 0);

    if ($coin_id == 'STARS_ONLY') {
        // دریافت قیمت پایه استارز از دیتابیس
        $base = get_setting_val_raw('star_usd', 0.016);
        if($base <= 0) $base = 0.016;
        
        $starsPrice = $base * $usdt * (1 + $margin);
        $usd = $base;
        $sym = "STARS"; 
        $ch = 0;
    } else {
        $data = get_crypto_data_cached($coin_id);
        if (empty($data) || !isset($data[$coin_id]['usd'])) return ['ok' => false, 'text' => "❌ خطا در دریافت اطلاعات ارز."];
        $usd = $data[$coin_id]['usd'];
        $ch = $data[$coin_id]['usd_24h_change'] ?? 0;
        $sym = strtoupper(substr($coin_id, 0, 4));
        if ($coin_id == 'the-open-network') $sym = 'TON';
    }

    $total_usd = $usd * $quantity;
    $total_toman = $total_usd * $usdt;

    $toman_str = number_format($total_toman);
    $usd_str = ($total_usd < 0.01) ? number_format($total_usd, 6) : number_format($total_usd, 2);
    $change_str = ($coin_id == 'STARS_ONLY') ? "0.00%" : number_format($ch, 2) . "%";

    $out = "<b>$quantity $sym :</b>\n";
    $out .= "<blockquote>";
    $out .= "💴 Toman : $toman_str\n";
    $out .= "💵 Dollar : \$$usd_str\n";
    $out .= "📊 Change : $change_str";
    $out .= "</blockquote>\n";
    $out .= get_clean_date();

    return ['ok' => true, 'text' => $out];
}

function get_generic_list() {
    global $db;
    $usdt_rate = get_setting_val('usd_irr', 70000);
    $data = get_crypto_data_cached('tether,bitcoin,toncoin,notcoin,solana,ethereum');
    
    $out = "📊 <b>Market Prices:</b>\n\n";
    $out .= "<blockquote>";
    $map = ['tether' => '🇺🇸 USDT', 'bitcoin' => '🟡 BTC', 'ethereum' => '🔵 ETH', 'toncoin' => '💎 TON', 'notcoin' => '⚫️ NOT'];

    if($data) {
        foreach ($map as $slug => $name) {
            if (isset($data[$slug])) {
                $p_toman = number_format($data[$slug]['usd'] * $usdt_rate);
                $change = round($data[$slug]['usd_24h_change'], 2);
                $emoji = $change >= 0 ? '🟢' : '🔴';
                $out .= "$name: $p_toman T ($emoji $change%)\n";
            }
        }
    } else {
        $out .= "⚠️ در حال بروزرسانی...";
    }
    $out .= "</blockquote>" . get_clean_date();
    return ['text' => $out];
}

function analyze_ton_wallet($address) {
    global $db;
    $usdt = get_setting_val('usd_irr', 70000);
    $ton = get_setting_val('ton_price_usd', 5.5);
    $res = fetch_url_advanced("https://toncenter.com/api/v2/getAddressInformation?address=" . $address);
    $data = json_decode($res, true);
    $short = substr($address, 0, 4) . "..." . substr($address, -4);
    $out = "👛 <b>کیف پول (Wallet Info):</b>\n🆔 <code>$short</code>\n";
    if (isset($data['ok']) && $data['ok']) {
        $tb = $data['result']['balance'] / 1000000000;
        $tm = number_format($tb * $ton * $usdt);
        $usd = number_format($tb * $ton, 2);
        $out .= "<blockquote>💎 Balance : " . number_format($tb, 4) . " TON\n💵 Value : $$usd\n💴 Toman : $tm T</blockquote>";
    } else { $out .= "❌ کیف پول یافت نشد."; }
    return ['text' => $out . "\n" . get_clean_date()];
}

function analyze_fragment_generic($type, $value) {
    global $db;
    $usdt = get_setting_val('usd_irr', 70000);
    $q_ton = $db->query("SELECT columnTwo FROM settings WHERE type_id='ton_price_usd'");
    $ton_usd = ($q_ton && $q_ton->num_rows > 0) ? $q_ton->fetch_assoc()['columnTwo'] : 5.5;
    $url = "https://fragment.com/$type/$value";
    $html = fetch_url_advanced($url);
    $status = "🔴 نامشخص"; $price_ton = 0;
    if ($html && preg_match('/<meta property="og:description" content="(.*?)">/', $html, $m)) {
        if (stripos($m[1], 'bid') !== false) { $status = "🟡 حراج"; preg_match('/([\d,]+)\s*TON/', $m[1], $p); $price_ton = floatval(str_replace(',', '', $p[1])); }
        elseif (stripos($m[1], 'Sold') !== false) { $status = "🔴 فروخته"; preg_match('/([\d,]+)\s*TON/', $m[1], $p); $price_ton = floatval(str_replace(',', '', $p[1])); }
        elseif (stripos($m[1], 'Put up') !== false) $status = "🟢 آزاد";
    }
    $disp = ($type == 'number') ? "+888 " . substr($value, 3) : "@$value";
    $out = "💎 <b>بررسی $type:</b>\n🆔 <b>$disp</b>\n📊 $status\n";
    if ($price_ton > 0) { $tm = number_format($price_ton * $ton_usd * $usdt); $out .= "<blockquote>💰 " . number_format($price_ton) . " TON\n💴 $tm T</blockquote>"; }
    return ['text' => $out . "\n" . get_clean_date()];
}

function get_telegram_gift_price($input) {
    global $db, $starsPrice;
    $usdt = get_setting_val('usd_irr', 70000);
    $ton = get_setting_val('ton_price_usd', 5.5);
    
    // دریافت قیمت استارز از تنظیمات
    $star_base = get_setting_val_raw('star_usd', 0.016);
    if($star_base <= 0) $star_base = 0.016;
    $starsPrice = $star_base * $usdt;

    $gifts = ['کیک'=>3,'cake'=>3,'ستاره'=>5,'star'=>5,'قلب'=>15,'heart'=>15];
    $k = strtolower(trim($input)); $s = 0;
    foreach($gifts as $gk=>$gv) if(strpos($gk, $k)!==false) { $s=$gv; break; }
    if ($s > 0) {
        $tm = number_format($s * $starsPrice);
        $tn = number_format(($s * $star_base)/$ton, 4);
        return ['text' => "🎁 <b>Gift:</b>\n<blockquote>💴 Toman : $tm\n💎 Ton : $tn\n⭐️ Cost : $s Stars</blockquote>\n".get_clean_date()];
    }
    return ['text' => "❌ یافت نشد."];
}

// ------------------------------------------------------------
// 🛠 ماشین حساب فیکس شده (بدون باگ و مپینگ کامل)
// ------------------------------------------------------------
function process_conversion($amount, $fr, $to) {
    global $db; 
    $usdt = get_setting_val('usd_irr', 70000);

    $fr = strtolower(trim($fr));
    $to = strtolower(trim($to));

    $map = [
        'تتر'=>'tether', 'usdt'=>'tether', 'دلار'=>'tether',
        'تون'=>'the-open-network', 'ton'=>'the-open-network',
        'تومان'=>'toman', 'toman'=>'toman', 'irr'=>'toman',
        'استارز'=>'STARS_ONLY', 'star'=>'STARS_ONLY', 'stars'=>'STARS_ONLY', 'ستاره'=>'STARS_ONLY',
        'بیت'=>'bitcoin', 'btc'=>'bitcoin',
        'نات'=>'notcoin', 'not'=>'notcoin',
        'ترون'=>'tron', 'trx'=>'tron',
        'سولانا'=>'solana', 'sol'=>'solana',
        'دوج'=>'dogecoin', 'doge'=>'dogecoin',
        'شیبا'=>'shiba-inu', 'shib'=>'shiba-inu',
        'همستر'=>'hamster-kombat', 'hmstr'=>'hamster-kombat',
        'داگز'=>'dogs-2', 'dogs'=>'dogs-2',
        'کتز'=>'cats-2', 'cats'=>'cats-2',
        'ایکس'=>'x-empire', 'x'=>'x-empire',
        'میجر'=>'major', 'major'=>'major',
        'بایننس'=>'binancecoin', 'bnb'=>'binancecoin',
        'ریپل'=>'ripple', 'xrp'=>'ripple',
        'لایت'=>'litecoin', 'ltc'=>'litecoin',
        'اتریوم'=>'ethereum', 'eth'=>'ethereum'
    ];

    $id_from = $map[$fr] ?? $fr;
    $id_to   = $map[$to] ?? $to;

    $p1 = get_usd_p($id_from, $usdt); 
    $p2 = get_usd_p($id_to, $usdt);

    if ($p2 <= 0 || $p1 <= 0) {
        return ['ok'=>false, 'text'=>"❌ خطا: قیمت ارز مبدا یا مقصد یافت نشد."];
    }

    $final_val = ($amount * $p1) / $p2;
    $res = ($final_val < 1) ? number_format($final_val, 6) : number_format($final_val, 2);
    
    return ['ok'=>true, 'text'=>"🔄 <b>تبدیل ارز:</b>\n<blockquote>💎 $amount ".strtoupper($fr)."\n💰 $res ".strtoupper($to)."</blockquote>\n".get_clean_date()];
}

function get_usd_p($id, $u) { 
    global $db;
    if($id=='toman') return (1/$u); 
    if($id=='tether') return 1; 
    
    // فیکس باگ استارز در ماشین حساب
    if($id=='STARS_ONLY') {
        $base = get_setting_val_raw('star_usd', 0.016);
        return ($base > 0) ? $base : 0.016;
    }
    
    $d=get_crypto_data_cached($id); 
    return $d[$id]['usd']??0; 
}

function get_crypto_data_cached($id) {
    $f = 'crypto_cache.json';
    if(file_exists($f) && time()-filemtime($f)<120) {
        $j=json_decode(file_get_contents($f),true);
        $ids = explode(',', $id); $all=true; foreach($ids as $i) if(!isset($j[$i])) $all=false; if($all) return $j;
    }
    $res = fetch_url_advanced("https://api.coingecko.com/api/v3/simple/price?ids=$id&vs_currencies=usd&include_24hr_change=true");
    $j = json_decode($res, true);
    if (!$j) {
         $b_map = ['bitcoin'=>'BTCUSDT','ethereum'=>'ETHUSDT','toncoin'=>'TONUSDT','tether'=>'USDTUSDT'];
         foreach(explode(',', $id) as $i) if(isset($b_map[$i])) {
             $br = fetch_url_advanced("https://api.binance.com/api/v3/ticker/24hr?symbol=".$b_map[$i]);
             $bd = json_decode($br, true); if(isset($bd['lastPrice'])) $j[$i] = ['usd'=>$bd['lastPrice'], 'usd_24h_change'=>$bd['priceChangePercent']];
         }
    }
    if($j) file_put_contents($f, json_encode($j));
    return $j;
}

function fetch_url_advanced($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)']);
    $res = curl_exec($ch); curl_close($ch); return $res;
}
function send_final_message($c, $m, $t, $k) { global $MahdyarEn; $MahdyarEn->Sendmessage(['chat_id'=>$c, 'text'=>$t, 'reply_markup'=>$k, 'reply_to_message_id'=>$m, 'parse_mode'=>'html', 'disable_web_page_preview'=>true]); }
function get_setting_val($t, $d) { global $db; if(!isset($db)) return $d; $q=$db->query("SELECT columnTwo FROM settings WHERE type_id='$t'"); return ($q && $q->num_rows > 0) ? $q->fetch_assoc()['columnTwo'] : $d; }
function get_setting_val_raw($t, $d) { global $db; if(!isset($db)) return $d; $q=$db->query("SELECT type_id FROM settings WHERE `type`='$t'"); return ($q && $q->num_rows > 0) ? $q->fetch_assoc()['type_id'] : $d; }
?>