<?php
date_default_timezone_set('Asia/Tehran');
ini_set('error_logs', 'off');

// require 
require_once 'class/Base.php';
require_once 'config.php';
require_once 'jdf.php';

$MahdyarEn = new Base($token);

// --- تنظیمات تاپیک‌ها برای فایل بک ---
// آیدی گروه مدیریتی (حتما باید سوپرگروه باشد)
$adminGroupId = "-1003325490390"; // لطفا آیدی عددی گروه خود را اینجا قرار دهید

// لیست آیدی تاپیک‌ها
$topics = [
    'deposit'  => 134,  // آیدی تاپیک افزایش موجودی
];

// تابع ارسال گزارش به تاپیک
function sendLog($type, $text, $keyboard = null) {
    global $MahdyarEn, $adminGroupId, $topics;
    
    $threadId = isset($topics[$type]) ? $topics[$type] : null;

    $params = [
        'chat_id' => $adminGroupId,
        'text' => $text,
        'parse_mode' => 'html',
        'disable_web_page_preview' => true
    ];

    if ($threadId) {
        $params['message_thread_id'] = $threadId;
    }

    if ($keyboard) {
        $params['reply_markup'] = $keyboard;
    }

    return $MahdyarEn->Sendmessage($params);
}
// -------------------------------------

$authority = $MahdyarEn->protect($db, $_GET['Authority']);

$pay = $db->query("SELECT * FROM pay WHERE `authority` = '$authority'")->fetch_assoc();
@$time = jdate('H:i:s');
$date = jdate('Y/m/d');

// بررسی وضعیت پرداخت
if ($_GET['Status'] == 'OK') {
    $res = $MahdyarEn->zarinPallPaymentVerification($zarinPallMerchant, $authority, $pay['price']);
    $user = $pay['id'];

    if ($res['data']['code'] == 100) {
        // 1. پیام به کاربر
        $MahdyarEn->Sendmessage([
            'chat_id' => $user, 
            'text' => "✅ پرداخت شما با موفقیت انجام شد.\n\n" .
                      "🔖 <b>شماره فاکتور:</b> <code>{$pay['factor']}</code>\n" .
                      "💰 <b>مبلغ:</b> " . number_format($pay['price']) . " تومان\n" .
                      "⏱ <b>زمان:</b> $time\n" .
                      "💳 موجودی حساب شما شارژ شد.", 
            'parse_mode' => 'html'
        ]);

        // 2. افزایش موجودی در دیتابیس
        $db->query("UPDATE user SET stock = stock+{$pay['price']} WHERE id = '$user'");
        
        // 3. آپدیت وضعیت تراکنش
        $db->query("UPDATE pay SET stats = 1 WHERE `factor` = '{$pay['factor']}'");

        // 4. ارسال لاگ حرفه‌ای به تاپیک ادمین
        $refID = $res['data']['ref_id'];
        $cardPan = isset($res['data']['card_pan']) ? $res['data']['card_pan'] : 'نامشخص';

        $logText = "💳 <b>افزایش موجودی: درگاه بانکی (زرین‌پال)</b>\n";
        $logText .= "────────────────\n";
        $logText .= "👤 <b>کاربر:</b> <a href='tg://user?id=$user'>$user</a>\n";
        $logText .= "💰 <b>مبلغ:</b> " . number_format($pay['price']) . " تومان\n";
        $logText .= "🔢 <b>کد رهگیری (RefID):</b> <code>$refID</code>\n";
        $logText .= "💳 <b>شماره کارت:</b> <code>$cardPan</code>\n";
        $logText .= "🧾 <b>شماره فاکتور:</b> <code>{$pay['factor']}</code>\n";
        $logText .= "📅 <b>زمان:</b> $date | $time";

        sendLog('deposit', $logText);

        echo 'پرداخت با موفقیت انجام و حساب شما شارژ شد. می‌توانید به ربات بازگردید.';

    } else if ($res['data']['code'] == 101) {
        echo 'این پرداخت قبلاً تایید شده است.';
    } else {
        echo 'خطا در تایید تراکنش: ' . $res['data']['message'];
    }
} else {
    echo 'پرداخت توسط کاربر لغو شد یا ناموفق بود.';
}